package ru.yandex.calendar.logic.sharing.perm;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.inside.passport.PassportUid;

@Getter
@AllArgsConstructor
public class EventFieldsForPermsCheck {
    public static final ListF<MapField<?>> FIELDS = Cf.list(
            EventFields.ID, EventFields.TYPE, EventFields.CREATOR_UID,
            EventFields.PERM_ALL, EventFields.PERM_PARTICIPANTS, EventFields.PARTICIPANTS_INVITE);

    private final long id;
    private final PassportUid creatorUid;
    private final EventType type;
    private final EventActionClass permAll;
    private final EventActionClass permParticipants;
    private final boolean participantsInvite;

    public static String columns(String eventPrefix) {
        return FIELDS.map(BeanHelper.columnNameF(eventPrefix)).mkString(",");
    }

    public static RowMapper<EventFieldsForPermsCheck> rowMapper(String prefix) {
        return (rs, num) -> fromEvent(BeanHelper.populateFields(Event.class, FIELDS, rs, prefix));
    }

    public static EventFieldsForPermsCheck fromEvent(Event event) {
        return new EventFieldsForPermsCheck(
                event.getId(), event.getCreatorUid(), event.getType(),
                event.getPermAll(), event.getPermParticipants(), event.getParticipantsInvite());
    }
}
