package ru.yandex.calendar.logic.sharing.perm;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.calendar.logic.layer.UserLayersSharing;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.inside.passport.PassportUid;

@Getter
@AllArgsConstructor
public class EventInfoForPermsCheck {
    private final long eventId;
    private final EventType type;
    private final PassportUid creatorUid;
    private final EventActionClass permAll;
    private final EventActionClass permParticipants;
    private final boolean participantsCanInvite;
    private final Option<ParticipantId> organizer;
    private final boolean organizerLetToEditAnyMeeting;
    private final ListF<ResourceInfoForPermsCheck> resources;
    private final Option<LayerInfoForPermsCheck> primaryLayer;
    private final UserLayersSharing userLayersSharing;
    private final boolean userIsAttendee;
    private final boolean userHasEventLayer;
    private final boolean userHasEventOnLayerSharedWithViewPerm;
    private final boolean hasSuperSecret;
    private final boolean hasSuperSecretAndUserIsNotKeeper;
    private final boolean hasSuperSecretUserIsKeep;

    public boolean isPrivate() {
        return hasSuperSecret || permAll == EventActionClass.NONE;
    }

    public ListF<Long> getResourceIds() {
        return resources.map(ResourceInfoForPermsCheck::getId);
    }
}
