package ru.yandex.calendar.logic.sharing.perm;

import java.util.List;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.experimental.FieldDefaults;
import one.util.streamex.StreamEx;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerFields;
import ru.yandex.calendar.logic.beans.generated.LayerHelper;
import ru.yandex.calendar.logic.layer.LayerType;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.inside.passport.PassportUid;

@Getter
@AllArgsConstructor
@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
public class LayerInfoForPermsCheck {
    long id;
    LayerType type;
    PassportUid creatorUid;

    private static final List<MapField<?>> LAYER_FIELDS = List.of(LayerFields.ID, LayerFields.TYPE, LayerFields.CREATOR_UID);

    public static String columns(String prefix) {
        return StreamEx.of(LAYER_FIELDS).map(BeanHelper.columnNameF(prefix)).joining(", ");
    }

    public static RowMapper<LayerInfoForPermsCheck> rowMapper(int columnOffset) {
        return LayerHelper.INSTANCE.offsetRowMapper(columnOffset, Cf.toList(LAYER_FIELDS))
            .andThen(LayerInfoForPermsCheck::fromLayer);
    }

    public static LayerInfoForPermsCheck fromLayer(Layer l) {
        return new LayerInfoForPermsCheck(l.getId(), l.getType(), l.getCreatorUid());
    }
}
