package ru.yandex.calendar.logic.sharing.perm;

import java.util.Optional;

import javax.inject.Inject;

import lombok.val;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.calendar.micro.perm.EventAction;
import ru.yandex.calendar.micro.perm.LayerAction;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

public class PermXmlizer {
    @Autowired
    private Authorizer authorizer;
    @Inject
    private LayerRoutines layerRoutines;

    /**
     * @see PermXmlizer#appendLayerPermElms(Element, Option, long, ActionSource, LayerAction...)
     */
    public static void appendPermElm(Element eParent, String actionXmlName, boolean value) {
        val xmlName = "can-" + actionXmlName;
        CalendarXmlizer.appendElm(eParent, xmlName, value, null);
    }

    public static void appendPermElm(Element eParent, EventAction eventAction, boolean value) {
        appendPermElm(eParent, eventAction.toXmlName(), value);
    }

    public void appendLayerPermElms(Element eParent, Option<UserInfo> userO, long targetId,
                                    ActionSource actionSource, LayerAction... actions) {
        for (LayerAction action : actions) {
            val layer = layerRoutines.getLayerById(targetId);
            val layerPermInfo = LayerInfoForPermsCheck.fromLayer(layer);
            val canPerform = userO
                .map(user -> authorizer.canPerformLayerAction(user, layerPermInfo, Optional.empty(), action, actionSource))
                .getOrElse(() -> authorizer.canPerformLayerAction(layerPermInfo, action, actionSource));
            appendPermElm(eParent, action.toXmlName(), canPerform);
        }
    }
}
