package ru.yandex.calendar.logic.sharing.perm;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.beans.generated.ResourceFields;
import ru.yandex.calendar.logic.beans.generated.ResourceHelper;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.commune.mapObject.MapField;

@Getter
@AllArgsConstructor
public class ResourceInfoForPermsCheck {
    private final long id;
    private final String domain;
    private final ResourceType type;
    private final Option<Integer> accessGroup;

    private static final ListF<MapField<?>> RESOURCE_FIELDS =
            Cf.list(ResourceFields.ID, ResourceFields.DOMAIN, ResourceFields.TYPE, ResourceFields.ACCESS_GROUP);

    public static String columns(String prefix) {
        return RESOURCE_FIELDS.map(BeanHelper.columnNameF(prefix)).mkString(", ");
    }

    public static RowMapper<ResourceInfoForPermsCheck> rowMapper(int columnOffset) {
        return ResourceHelper.INSTANCE.offsetRowMapper(columnOffset, RESOURCE_FIELDS)
            .andThen(ResourceInfoForPermsCheck::fromResource);
    }

    public static ResourceInfoForPermsCheck fromResource(Resource r) {
        return new ResourceInfoForPermsCheck(r.getId(), r.getDomain(), r.getType(), r.getAccessGroup());
    }
}
