package ru.yandex.calendar.logic.staff;

import java.io.IOException;

import com.amazonaws.util.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.inside.utils.AuthenticatingClient;
import ru.yandex.inside.utils.OAuthAuthenticationHandler;
import ru.yandex.misc.io.http.UrlUtils;

public class DefaultStaffHttpProvider implements StaffHttpProvider {


    private final HttpClient httpClient;

    public DefaultStaffHttpProvider(String staffApiToken, HttpClient httpClient) {
        this.httpClient = new AuthenticatingClient(httpClient, new OAuthAuthenticationHandler(staffApiToken));
    }


    @Override
    public String doRequest(String url, int limit, int page, String query, String fields) throws IOException {
        return doRequest(url, Cf.map("_page", String.valueOf(page),
                "_query", query, "_fields", fields, "_limit", String.valueOf(limit)));
    }

    @Override
    public String doRequest(String url, MapF<String, String> params) throws IOException {
        for (String key : params.keySet()) {
            url = UrlUtils.addParameter(url, key, params.getO(key).get());
        }

        var request = new HttpGet(url);

        var response = httpClient.execute(request);

        try {
            return IOUtils.toString(response.getEntity().getContent());
        } finally {
            EntityUtils.consumeQuietly(response.getEntity());
        }
    }
}
