package ru.yandex.calendar.logic.staff;


import java.io.IOException;

import com.amazonaws.util.json.JSONException;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.calendar.logic.staff.dao.GroupsDao;
import ru.yandex.calendar.logic.staff.dao.OfficesDao;
import ru.yandex.calendar.logic.staff.dao.RoomsDao;
import ru.yandex.calendar.logic.staff.dao.UsersDao;

@Slf4j
public class StaffSynchronizer {

    UsersDao usersDao;
    GroupsDao groupsDao;
    OfficesDao officesDao;
    RoomsDao roomsDao;

    private final int pageSize = 50;

    public StaffSynchronizer(UsersDao usersDao, GroupsDao groupsDao, OfficesDao officesDao, RoomsDao roomsDao) {
        this.usersDao = usersDao;
        this.groupsDao = groupsDao;
        this.officesDao = officesDao;
        this.roomsDao = roomsDao;
    }

    public void synchronize(StaffV3 staffV3) {

        log.info("Start staff synchronization");

        int pages;
        int pagesDeleted;
        int downloaded;
        int downloadedDeleted;
        int added;

        try {
            pages = staffV3.totalEntries("persons") / pageSize + 1;
            downloaded = 0;
            added = 0;
            for (int i = 1; i <= pages; ++i) {
                var users = staffV3.persons(pageSize, i, "", false);
                downloaded += users.size();
                added += usersDao.update(users);
            }
            log.info("Downloaded {} persons, added {} new persons", downloaded, added);
            //persons cannot be deleted

            pages = staffV3.totalEntries("groups") / pageSize + 1;
            pagesDeleted = staffV3.totalEntries("groups?is_deleted=true") / pageSize + 1;
            downloaded = 0;
            downloadedDeleted = 0;
            added = 0;
            for (int i = 1; i <= pages; ++i) {
                var groups = staffV3.groups(pageSize, i, "", false);
                downloaded += groups.size();
                added += groupsDao.update(groups);
            }
            for (int i = 1; i <= pagesDeleted; ++i) {
                var groups = staffV3.groups(pageSize, i, "", true);
                downloaded += groups.size();
                downloadedDeleted += groups.size();
                added += groupsDao.update(groups);
            }
            log.info("Downloaded {} groups, {} are deleted, added {} new groups", downloaded, downloadedDeleted, added);


            pages = staffV3.totalEntries("offices") / pageSize + 1;
            pagesDeleted = staffV3.totalEntries("offices?is_deleted=true") / pageSize + 1;
            downloaded = 0;
            downloadedDeleted = 0;
            added = 0;
            for (int i = 1; i <= pages; ++i) {
                var offices = staffV3.offices(pageSize, i, "", false);
                downloaded += offices.size();
                added += officesDao.update(offices);
            }
            for (int i = 1; i <= pagesDeleted; ++i) {
                var offices = staffV3.offices(pageSize, i, "", true);
                downloaded += offices.size();
                downloadedDeleted += offices.size();
                added += officesDao.update(offices);
            }
            log.info("Downloaded {} offices, {} are deleted, added {} new offices", downloaded, downloadedDeleted, added);


            pages = staffV3.totalEntries("rooms") / pageSize + 1;
            pagesDeleted = staffV3.totalEntries("rooms?is_deleted=true") / pageSize + 1;
            downloaded = 0;
            downloadedDeleted = 0;
            added = 0;
            for (int i = 1; i <= pages; ++i) {
                var rooms = staffV3.rooms(pageSize, i, "", false);
                downloaded += rooms.size();
                added += roomsDao.update(rooms);
            }
            for (int i = 1; i <= pagesDeleted; ++i) {
                var rooms = staffV3.rooms(pageSize, i, "", true);
                downloaded += rooms.size();
                downloadedDeleted += rooms.size();
                added += roomsDao.update(rooms);
            }
            log.info("Downloaded {} rooms, {} are deleted, added {} new rooms", downloaded, downloadedDeleted, added);
        } catch (IOException | JSONException e) {
            log.error("Staff synchronization failed", e);
            return;
        }

        log.info("Staff synchronization complete successfully");

    }
}
