package ru.yandex.calendar.logic.staff.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import lombok.extern.slf4j.Slf4j;
import one.util.streamex.StreamEx;

import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;

@Slf4j
public abstract class StaffDao<T> extends CalendarJdbcDaoSupport {

    protected static ObjectMapper objectMapper = new ObjectMapper()
            .registerModule(new ParameterNamesModule())
            .registerModule(new Jdk8Module())
            .registerModule(new JavaTimeModule())
            .enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)
            .disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    protected abstract int[] insert(List<T> entities);

    public abstract int update(List<T> entities);

    public abstract List<T> getAll(int limit, int offset) throws JsonProcessingException;


    protected abstract int count();

    private final int pageSize = 1000;

    public List<T> getAll() throws JsonProcessingException {
        int c = count();
        List<T> result = new ArrayList<>();
        Set<T> set = new HashSet<>();
        for (int i = 0; i < c; i += pageSize) {
            var page = StreamEx.of(getAll(pageSize, i)).filter(x -> !set.contains(x)).toList();
            set.addAll(page);
            result.addAll(page);
        }
        return result;
    }
}
