package ru.yandex.calendar.logic.stat;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

/**
 * Contains increment information for daily stats' counters.
 * Used instead of direct change of {@link DailyStat},which
 * is actually not safe (several servants can overwrite data).
 * NOTE that we assume that all sending is made within a single
 * day (with non-significant error). Thus, this object is
 * created and updated only once.
 * For proper db update, use
 * {@link DailyStatRoutines#add(DailyStatIncrement)}.
 * @author ssytnik
 */
public class DailyStatIncrement {
    private LocalDate date;
    private int emailsSent;
    private int smsSent;

    public DailyStatIncrement() {
        this(new LocalDate(DateTimeZone.UTC));
    }
    public DailyStatIncrement(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDate() {
        return date;
    }

    public int getEmailsSent() {
        return emailsSent;
    }

    public int getSmsSent() {
        return smsSent;
    }

    public void incEmailsSent() {
        emailsSent++;
    }

    public void incSmsSent() {
        smsSent++;
    }

    public void setEmailsSent(int emailsSent) {
        this.emailsSent = emailsSent;
    }

    public void setSmsSent(int smsSent) {
        this.smsSent = smsSent;
    }

    @Override
    public String toString() {
        return "[" + date + ": " + emailsSent + " email(s), " + smsSent + " sms]";
    }
}
