package ru.yandex.calendar.logic.stat;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Daniel Brylev
 *
 * https://jira.yandex-team.ru/browse/CAL-4673
 */
public class TodoStatisticsManager {
    private static final Logger logger = LoggerFactory.getLogger(TodoStatisticsManager.class);

    @Autowired
    private TodoStatisticsDao todoStatisticsDao;
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;

    public ListF<TodoDailyStat> getStats() {
        return Cf.list();
    }

    public ListF<YandexMailTodoDailyStat> getYandexMailStats() {
        Check.isFalse(passportAuthDomainsHolder.containsYandexTeamRu(), "Cannot get Yandex.Mail stats for yandex-team");

        return YandexMailStatsParser.parseTodoDailyStats(
                ApacheHttpClientUtils.inputStreamSource("http://mdbdir.mail.yandex.net/run/mdbstats.todos_json", Timeout.seconds(2)));
    }
}
