package ru.yandex.calendar.logic.stat;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author Daniel Brylev
 */
public class YandexMailStatsParser {

    public static ListF<YandexMailTodoDailyStat> parseTodoDailyStats(InputStreamSource source) {
        JsonArray array = JsonParser.getInstance().parseArray(source.readText());
        JsonObject object = (JsonObject) Cf.x(array.getArray()).single();
        JsonArray data = (JsonArray) object.get("data");

        ListF<YandexMailTodoDailyStat> stats = Cf.arrayList();
        for (JsonArray stat : Cf.x(data.getArray()).cast(JsonArray.class)) {
            Validate.sizeIs(2, stat.getArray());

            long timestamp = ((JsonNumber) Cf.x(stat.getArray()).first()).longValue();
            int usersWithShowTodoSettingOn = ((JsonNumber) Cf.x(stat.getArray()).last()).intValue();

            stats.add(new YandexMailTodoDailyStat(new LocalDate(timestamp, MoscowTime.TZ), usersWithShowTodoSettingOn));
        }
        return stats;
    }
}
