package ru.yandex.calendar.logic.stat;

import org.joda.time.LocalDate;

import ru.yandex.bolts.function.Function;

/**
 * @author Daniel Brylev
 */
public class YandexMailTodoDailyStat {
    private final LocalDate date;
    private final int usersWithShowTodoSettingOn;

    public YandexMailTodoDailyStat(LocalDate date, int usersWithShowTodoSettingOn) {
        this.date = date;
        this.usersWithShowTodoSettingOn = usersWithShowTodoSettingOn;
    }

    public LocalDate getDate() {
        return date;
    }

    public int getUsersWithShowTodoSettingOn() {
        return usersWithShowTodoSettingOn;
    }

    public static Function<YandexMailTodoDailyStat, LocalDate> getDateF() {
        return new Function<YandexMailTodoDailyStat, LocalDate>() {
            public LocalDate apply(YandexMailTodoDailyStat s) {
                return s.getDate();
            }
        };
    }
}
