package ru.yandex.calendar.logic.suggest;

import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author gutman
 */
public class AvailableResourcesFinder {

    private final UsersAndResourcesAvailability usersAndResourcesAvailability;
    private final Instant eventStart;
    private final Duration eventDuration;
    private final InstantInterval searchInterval;
    private final IntervalSet muteIntervals;

    public AvailableResourcesFinder(
            UsersAndResourcesAvailability usersAndResourcesAvailability, Instant eventStart,
            Duration eventDuration, InstantInterval searchInterval)
    {
        this(usersAndResourcesAvailability, eventStart, eventDuration, searchInterval, IntervalSet.empty());
    }

    public AvailableResourcesFinder(
            UsersAndResourcesAvailability usersAndResourcesAvailability,
            Instant eventStart, Duration eventDuration, InstantInterval searchInterval,
            IntervalSet muteIntervals)
    {
        this.usersAndResourcesAvailability = usersAndResourcesAvailability;
        this.eventStart = eventStart;
        this.eventDuration = eventDuration;
        this.searchInterval = searchInterval;
        this.muteIntervals = muteIntervals;
    }

    public ListF<AvailableResourcesInOffices> findAvailableResourcesInOffices() {
        ListF<AvailableResourcesInOffices> availableResourcess = Cf.arrayList();

        for (InstantInterval i : SuggestUtils.getIntervalsToLookup(searchInterval, eventStart, eventDuration)) {
            Option<AvailableResourcesInOffices> availableResources =
                    usersAndResourcesAvailability.getAvailableResourcesIfAllOfficesAreAvailable(i);

            if (availableResources.isPresent() && !muteIntervals.contains(i.getStart())) {
                availableResourcess.add(availableResources.get());
            }
        }
        return availableResourcess;
    }

    public ListF<LocalDate> findDatesWithAvailableResourcesInOffices(DateTimeZone tz) {
        SetF<LocalDate> dates = Cf.hashSet();

        for (InstantInterval i : SuggestUtils.getIntervalsToLookup(searchInterval, eventStart, eventDuration)) {
            LocalDate date = new LocalDate(i.getStart(), tz);

            if (!dates.containsTs(date)) {
                if (usersAndResourcesAvailability.getAvailableResourcesIfAllOfficesAreAvailable(i).isPresent()) {
                    dates.add(date);
                }
            }
        }
        return dates.sorted();
    }

}
