package ru.yandex.calendar.logic.suggest;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author gutman
 */
public class AvailableResourcesInOffices {

    private final InstantInterval interval;
    private final ListF<OfficeAndFreeResources> officeAndFreeResources;

    private AvailableResourcesInOffices(InstantInterval interval, ListF<OfficeAndFreeResources> officeAndFreeResources) {
        Validate.isTrue(
                officeAndFreeResources.length() ==
                officeAndFreeResources.map(OfficeAndFreeResources.getOfficeF().andThen(Office.getIdF())).unique().size());
        this.interval = interval;
        this.officeAndFreeResources = officeAndFreeResources;
    }

    static AvailableResourcesInOffices empty(InstantInterval interval) {
        return new AvailableResourcesInOffices(interval, Cf.<OfficeAndFreeResources>list());
    }

    AvailableResourcesInOffices plusOne(Office office, Tuple2List<ResourceInfo, Option<LocalDate>> availableResources) {
        return new AvailableResourcesInOffices(this.interval, this.officeAndFreeResources
                .plus(new OfficeAndFreeResources(office, availableResources)));
    }

    public Instant getStart() {
        return interval.getStart();
    }

    public Instant getEnd() {
        return interval.getEnd();
    }

    public InstantInterval getInterval() {
        return interval;
    }

    public ListF<OfficeAndFreeResources> getOfficeAndFreeResources() {
        return officeAndFreeResources;
    }

    public static Function<AvailableResourcesInOffices, InstantInterval> getIntervalF() {
        return new Function<AvailableResourcesInOffices, InstantInterval>() {
            public InstantInterval apply(AvailableResourcesInOffices availableResourcesInOffices) {
                return availableResourcesInOffices.interval;
            }
        };
    }

}
