package ru.yandex.calendar.logic.suggest;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class DayTime extends DefaultObject implements Comparable<DayTime> {
    private final int day;
    private final LocalTime time;

    public DayTime(int day, LocalTime time) {
        this.day = day;
        this.time = time;
    }

    public DayTime(LocalDate base, ReadableInstant instant, DateTimeZone tz) {
        this(new Period(base, new LocalDate(instant, tz)).getDays(), new LocalTime(instant, tz));
    }

    public int getDay() {
        return day;
    }

    public LocalTime getTime() {
        return time;
    }

    public LocalDateTime toLocalDateTime(LocalDate base) {
        return base.plusDays(day).toLocalDateTime(time);
    }

    public boolean isEqual(DayTime that) {
        return this.day == that.day && this.time.isEqual(that.time);
    }

    public boolean isBefore(DayTime that) {
        return this.day < that.day || this.day == that.day && this.time.isBefore(that.time);
    }

    public boolean isAfter(DayTime that) {
        return this.day > that.day || this.day == that.day && this.time.isAfter(that.time);
    }

    @Override
    public int compareTo(DayTime that) {
        Validate.notNull(that);
        int cmp = Integer.compare(this.day, that.day);
        return cmp == 0 ? this.time.compareTo(that.time) : cmp;
    }
}
