package ru.yandex.calendar.logic.suggest;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class DayTimeInterval {
    private final DayTime start;
    private final DayTime end;

    public DayTimeInterval(DayTime start, DayTime end) {
        Validate.isFalse(end.isBefore(start));
        this.start = start;
        this.end = end;
    }

    public DayTimeInterval(InstantInterval interval, DateTimeZone tz) {
        this(new DayTime(new LocalDate(interval.getStart(), tz), interval.getStart(), tz),
                new DayTime(new LocalDate(interval.getStart(), tz), interval.getEnd(), tz));
    }

    public InstantInterval toInstantInterval(LocalDate base, DateTimeZone tz) {
        return new InstantInterval(start.toLocalDateTime(base).toDateTime(tz), end.toLocalDateTime(base).toDateTime(tz));
    }

    public DayTime getStart() {
        return start;
    }

    public DayTime getEnd() {
        return end;
    }
}
