package ru.yandex.calendar.logic.suggest;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class LocalTimeOverlap extends DefaultObject {
    private final DayTime start;
    private final DayTime end;
    private final LocalDate sinceDate;

    public LocalTimeOverlap(DayTime start, DayTime end, LocalDate sinceDate) {
        Validate.isFalse(end.isBefore(start));

        this.start = start;
        this.end = end;
        this.sinceDate = sinceDate;
    }

    public LocalTimeOverlap withStart(DayTime start) {
        return new LocalTimeOverlap(start, end, sinceDate);
    }

    public LocalTimeOverlap withEnd(DayTime end) {
        return new LocalTimeOverlap(start, end, sinceDate);
    }

    public DayTime getStart() {
        return start;
    }

    public DayTime getEnd() {
        return end;
    }

    public DateTime getStartDateTime(LocalDate base, DateTimeZone tz) {
        return getStart().toLocalDateTime(base).toDateTime(tz);
    }

    public DateTime getEndDateTime(LocalDate base, DateTimeZone tz) {
        return getEnd().toLocalDateTime(base).toDateTime(tz);
    }

    public LocalDate getSinceDate() {
        return sinceDate;
    }

    public static Function<LocalTimeOverlap, DayTime> getStartF() {
        return LocalTimeOverlap::getStart;
    }

}
