package ru.yandex.calendar.logic.suggest;

import java.util.PriorityQueue;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.misc.lang.ObjectUtils;

/**
 * @author dbrylev
 */
public class LocalTimeOverlaps {
    private final ListF<LocalTimeOverlap> overlaps;

    private LocalTimeOverlaps(ListF<LocalTimeOverlap> overlaps) {
        this.overlaps = overlaps;
    }

    public static LocalTimeOverlaps empty() {
        return new LocalTimeOverlaps(Cf.<LocalTimeOverlap>list());
    }

    public LocalTimeOverlaps union(ListF<LocalTimeOverlap> overlaps) {
        return new LocalTimeOverlaps(merge(this.overlaps.plus(overlaps)));
    }

    public LocalTimeOverlaps union(LocalTimeOverlaps other) {
        return new LocalTimeOverlaps(merge(this.overlaps.plus(other.overlaps)));
    }

    static ListF<LocalTimeOverlap> merge(ListF<LocalTimeOverlap> overlaps) {
        if (overlaps.isEmpty()) return Cf.list();

        Comparator<LocalTimeOverlap> comparator = LocalTimeOverlap.getStartF().andThenNaturalComparator();

        PriorityQueue<LocalTimeOverlap> queue = new PriorityQueue<LocalTimeOverlap>(overlaps.size(), comparator);
        queue.addAll(overlaps);

        ListF<LocalTimeOverlap> merged = Cf.arrayList();
        while (queue.size() > 1) {
            LocalTimeOverlap left = queue.remove();
            LocalTimeOverlap right = queue.remove();

            if (left.getEnd().isBefore(right.getStart())) {
                merged.add(left);
                queue.add(right);

            } else if (left.getSinceDate().equals(right.getSinceDate())) {
                queue.add(left.withEnd(ObjectUtils.max(left.getEnd(), right.getEnd())));

            } else if (left.getEnd().isEqual(right.getStart())) {
                merged.add(left);
                queue.add(right);

            } else {
                LocalTimeOverlap upper = left.getSinceDate().isBefore(right.getSinceDate()) ? left : right;
                LocalTimeOverlap lower = left.getSinceDate().isBefore(right.getSinceDate()) ? right : left;

                queue.add(upper);
                if (lower.getStart().isBefore(upper.getStart())) queue.add(lower.withEnd(upper.getStart()));
                if (lower.getEnd().isAfter(upper.getEnd())) queue.add(lower.withStart(upper.getEnd()));
            }
        }
        merged.addAll(queue);

        return merged;
    }

    public ListF<LocalTimeOverlap> getOverlaps() {
        return overlaps;
    }
}
