package ru.yandex.calendar.logic.suggest;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.misc.lang.Validate;

/**
* @author gutman
*/
public class OfficeAndFreeResources {

    private final Office office;
    private final Tuple2List<ResourceInfo, Option<LocalDate>> availableResources;

    OfficeAndFreeResources(Office office, Tuple2List<ResourceInfo, Option<LocalDate>> availableResources) {
        Validate.forAll(availableResources.get1(), ResourceInfo.officeIdF().andThenEquals(office.getId()));
        this.office = office;
        this.availableResources = availableResources;
    }

    public Office getOffice() {
        return office;
    }

    public Tuple2List<ResourceInfo, Option<LocalDate>> getAvailableResources() {
        return availableResources;
    }

    public static Function<OfficeAndFreeResources, Office> getOfficeF() {
        return new Function<OfficeAndFreeResources, Office>() {
            public Office apply(OfficeAndFreeResources officeAndFreeResources) {
                return officeAndFreeResources.office;
            }
        };
    }

    public static Function<OfficeAndFreeResources, Long> getOfficeIdF() {
        return getOfficeF().andThen(Office.getIdF());
    }

}
