package ru.yandex.calendar.logic.suggest;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
class OfficeAvailability {
    private final Office office;
    private final ListF<ResourceAvailability> resourcesAvailabilities;

    public OfficeAvailability(Office office, ListF<ResourceAvailability> resourceAvailabilities) {
        Validate.forAll(resourceAvailabilities, ResourceAvailability.getOfficeIdF().andThenEquals(office.getId()));

        this.office = office;
        this.resourcesAvailabilities = resourceAvailabilities;
    }

    public Tuple2List<ResourceInfo, Option<LocalDate>> getFreeResources(InstantInterval interval) {
        return resourcesAvailabilities
                .filter(ResourceAvailability.isFreeInF(interval))
                .toTuple2List(ResourceAvailability.getResourceInfoF(), ResourceAvailability.getFreeDueDateInF(interval));
    }

    public Office getOffice() {
        return office;
    }

    public long getOfficeId() {
        return office.getId();
    }

    public static Function<OfficeAvailability, Long> getOfficeIdF() {
        return new Function<OfficeAvailability, Long>() {
            public Long apply(OfficeAvailability officeAvailability) {
                return officeAvailability.getOffice().getId();
            }
        };
    }

    public static Function2<Office, ListF<ResourceAvailability>, OfficeAvailability> consF() {
        return new Function2<Office, ListF<ResourceAvailability>, OfficeAvailability>() {
            public OfficeAvailability apply(Office o, ListF<ResourceAvailability> as) {
                return new OfficeAvailability(o, as);
            }
        };
    }
}
