package ru.yandex.calendar.logic.suggest;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
class ResourceAvailability {
    private final ResourceInfo resourceInfo;
    private final FreeIntervalSet freeTimes;

    public ResourceAvailability(ResourceInfo resourceInfo, FreeIntervalSet freeTimes) {
        this.resourceInfo = resourceInfo;
        this.freeTimes = freeTimes;
    }

    public static ListF<OfficeAvailability> groupByOffices(ListF<ResourceAvailability> availabilities) {
        ListF<Office> offices = availabilities.map(getOfficeF()).stableUniqueBy(Office.getIdF());

        return offices.zipWith(Office.getIdF().andThen(Cf2.f(availabilities.groupBy(getOfficeIdF())::getOrThrow)))
                .map(OfficeAvailability.consF());
    }

    public static Function1B<ResourceAvailability> isFreeInF(final InstantInterval interval) {
        return new Function1B<ResourceAvailability>() {
            public boolean apply(ResourceAvailability resourceAvailability) {
                return resourceAvailability.freeTimes.isFreeIn(interval);
            }
        };
    }

    public static Function<ResourceAvailability, Option<LocalDate>> getFreeDueDateInF(final InstantInterval interval) {
        return new Function<ResourceAvailability, Option<LocalDate>>() {
            public Option<LocalDate> apply(ResourceAvailability resourceAvailability) {
                return resourceAvailability.freeTimes.getMinDueDateIn(interval);
            }
        };
    }

    public static Function<ResourceAvailability, Office> getOfficeF() {
        return getResourceInfoF().andThen(ResourceInfo.officeF());
    }

    public static Function<ResourceAvailability, Long> getOfficeIdF() {
        return getOfficeF().andThen(Office.getIdF());
    }

    public static Function<ResourceAvailability, ResourceInfo> getResourceInfoF() {
        return new Function<ResourceAvailability, ResourceInfo>() {
            public ResourceInfo apply(ResourceAvailability resourceAvailability) {
                return resourceAvailability.resourceInfo;
            }
        };
    }

    public static Function2<ResourceInfo, FreeIntervalSet, ResourceAvailability> consF() {
        return new Function2<ResourceInfo, FreeIntervalSet, ResourceAvailability>() {
            public ResourceAvailability apply(ResourceInfo resourceInfo, FreeIntervalSet freeTimes) {
                return new ResourceAvailability(resourceInfo, freeTimes);
            }
        };
    }
}
