package ru.yandex.calendar.logic.suggest;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.resource.schedule.ResourceEventsAndReservations;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class ResourceTimeline {
    private final ResourceInfo resource;
    private final IntervalSet freeTimes;
    private final ResourceEventsAndReservations busyTimes;

    public ResourceTimeline(
            ResourceInfo resource, IntervalSet freeTimes,
            ResourceEventsAndReservations busyTimes)
    {
        this.resource = resource;
        this.freeTimes = freeTimes;
        this.busyTimes = busyTimes;
    }

    public boolean isFreeIn(InstantInterval interval) {
        return freeTimes.contains(interval);
    }

    public int countFree(ListF<InstantInterval> intervals) {
        return intervals.count(this::isFreeIn);
    }

    public long getOfficeId() {
        return getOffice().getId();
    }

    public Office getOffice() {
        return resource.getOffice();
    }

    public long getResourceId() {
        return resource.getResourceId();
    }

    public ResourceInfo getResource() {
        return resource;
    }

    public IntervalSet getFreeTimes() {
        return freeTimes;
    }

    public ResourceEventsAndReservations getBusyTimes() {
        return busyTimes;
    }
}
