package ru.yandex.calendar.logic.suggest;

import org.joda.time.Instant;

import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class SearchInterval {
    private final InstantInterval interval;
    private final boolean forward;

    public SearchInterval(InstantInterval interval, boolean forward) {
        this.interval = interval;
        this.forward = forward;
    }

    public static SearchInterval forward(InstantInterval interval) {
        return new SearchInterval(interval, true);
    }

    public static SearchInterval backward(InstantInterval interval) {
        return new SearchInterval(interval, false);
    }

    public InstantInterval getInterval() {
        return interval;
    }

    public boolean isForward() {
        return forward;
    }

    public boolean isBackward() {
        return !forward;
    }

    public Instant getStart() {
        return interval.getStart();
    }

    public Instant getEnd() {
        return interval.getEnd();
    }
}
