package ru.yandex.calendar.logic.suggest;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.dates.AuxDateTime;

/**
 * @author Daniel Brylev
 */
public class Suggest {
    private final ListF<AvailableResourcesInOffices> suggestedIntervals;
    private final Option<Instant> backSearchStart;
    private final Option<Instant> nextSearchStart;

    public Suggest(ListF<AvailableResourcesInOffices> suggestedIntervals,
            Option<Instant> backSearchStart,
            Option<Instant> nextSearchStart)
    {
        this.suggestedIntervals = suggestedIntervals;
        this.backSearchStart = backSearchStart;
        this.nextSearchStart = nextSearchStart;
    }

    public static Suggest empty() {
        return new Suggest(Cf.<AvailableResourcesInOffices>list(), Option.<Instant>empty(), Option.<Instant>empty());
    }

    public ListF<AvailableResourcesInOffices> getSuggestedIntervals() {
        return suggestedIntervals;
    }

    public Option<Instant> getNextSearchStart() {
        return nextSearchStart;
    }

    public Option<Instant> getBackSearchStart() {
        return backSearchStart;
    }

    public Option<LocalDateTime> getNextSearchStart(DateTimeZone tz) {
        return nextSearchStart.map(AuxDateTime.instantLocalDateTimeF(tz));
    }

    public Option<LocalDateTime> getBackSearchStart(DateTimeZone tz) {
        return backSearchStart.map(AuxDateTime.instantLocalDateTimeF(tz));
    }
}
