package ru.yandex.calendar.logic.suggest;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class SuggestedDates {
    private final ListF<LocalDate> dates;
    private final Option<LocalDate> backwardDate;
    private final Option<LocalDate> forwardDate;

    public SuggestedDates(
            ListF<LocalDate> dates, Option<LocalDate> backwardDate, Option<LocalDate> forwardDate)
    {
        this.dates = dates;
        this.backwardDate = backwardDate;
        this.forwardDate = forwardDate;
    }

    public static SuggestedDates empty() {
        return new SuggestedDates(Cf.list(), Option.empty(), Option.empty());
    }

    public ListF<LocalDate> getDates() {
        return dates;
    }

    public Option<LocalDate> getBackwardDate() {
        return backwardDate;
    }

    public Option<LocalDate> getForwardDate() {
        return forwardDate;
    }
}
