package ru.yandex.calendar.logic.svc;

import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.PassportSid;


/**
 * @author Stepan Koltsov
 */
public class Service {

    private final PassportSid sid;
    private final String domainName;
    private final String name;
    private final String sName;
    private final String enName;
    private final String layerCssClass;
    private final int layerHeadBgColor;
    private final int layerHeadFgColor;
    private final int layerBodyBgColor;
    private final boolean showWhenPossible;

    public Service(
            PassportSid sid, String domainName, String name, String sName, String enName,
            String layerCssClass, int layerHeadBgColor, int layerHeadFgColor,
            int layerBodyBgColor, boolean showWhenPossible)
    {
        this.sid = sid;
        this.domainName = domainName;
        this.name = name;
        this.sName = sName;
        this.enName = enName;
        this.layerCssClass = layerCssClass;
        this.layerHeadBgColor = layerHeadBgColor;
        this.layerHeadFgColor = layerHeadFgColor;
        this.layerBodyBgColor = layerBodyBgColor;
        this.showWhenPossible = showWhenPossible;
    }

    public PassportSid getSid() {
        return sid;
    }

    public String getDomainName() {
        return domainName;
    }

    public String getName() {
        return name;
    }

    public String getSName() {
        return sName;
    }

    public String getEnName() {
        return enName;
    }

    public String getLayerCssClass() {
        return layerCssClass;
    }

    public int getLayerHeadBgColor() {
        return layerHeadBgColor;
    }

    public int getLayerHeadFgColor() {
        return layerHeadFgColor;
    }

    public int getLayerBodyBgColor() {
        return layerBodyBgColor;
    }

    public boolean isShowWhenPossible() {
        return showWhenPossible;
    }

    public static Function<Service, PassportSid> getSidF() {
        return new Function<Service, PassportSid>() {
            public PassportSid apply(Service s) {
                return s.getSid();
            }
        };
    }
}
