package ru.yandex.calendar.logic.telemost;

import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.misc.regex.Pattern2;

public interface TelemostConstants {

    int GENERATE_HOURS_BEFORE_START = 3;

    String FIELD_CONFERENCE_GENERATES = "generatesTelemost";
    String FIELD_CONFERENCE_LINK = "telemostLink";

    String FIELD_BROADCAST_GENERATES = "generatesTelemostBroadcast";
    String FIELD_BROADCAST_LINK = "telemostBroadcastLink";

    String LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_RU = "Ссылка на видеовстречу: ";
    String LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_EN = "Link to video conference: ";

    String LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_RU =
            "Ссылка на видеовстречу для организатора и участников: ";
    String LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_EN =
            "Link to video meeting for organizer and participants: ";

    String LINK_TO_BROADCAST_PREFIX_RU = "Ссылка на трансляцию для зрителей: ";
    String LINK_TO_BROADCAST_PREFIX_EN = "Link to stream for viewers: ";

    NameI18n LINK_TO_CONFERENCE_WITHOUT_BROADCAST_TEMPLATE = new NameI18n(
            LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_RU + "%s",
            LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_EN + "%s"
    );

    NameI18n LINK_TO_CONFERENCE_WITH_BROADCAST_TEMPLATE = new NameI18n(
            LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_RU + "%s\n\n"
                    + LINK_TO_BROADCAST_PREFIX_RU + "%s",
            LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_EN + "%s\n\n"
                    + LINK_TO_BROADCAST_PREFIX_EN + "%s"
    );

    String LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_RU =
            "Ссылка на видеовстречу появится здесь за 3 часа до встречи";
    String LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_EN =
            "The link to the video conference will appear here 3 hours before the start";

    String LINK_PROMISE_MESSAGE_WITH_BROADCAST_RU =
            "Ссылки на видеовстречу и трансляцию появятся здесь за 3 часа до встречи";
    String LINK_PROMISE_MESSAGE_WITH_BROADCAST_EN =
            "The links to the video conference and stream will appear here 3 hours before the start";

    NameI18n LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST = new NameI18n(
            LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_RU, LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_EN
    );

    NameI18n LINK_PROMISE_MESSAGE_WITH_BROADCAST = new NameI18n(
            LINK_PROMISE_MESSAGE_WITH_BROADCAST_RU, LINK_PROMISE_MESSAGE_WITH_BROADCAST_EN
    );

    Pattern2 MESSAGE_WITHOUT_BROADCAST_IN_DESCRIPTION_PATTERN = Pattern2.compile("" +
            "(?:" +
            "(?:" + LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_RU +
            "|" + LINK_TO_CONFERENCE_WITHOUT_BROADCAST_PREFIX_EN + "" +
            ")https://telemost\\.[^\\s]+" +
            "|" + LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_RU +
            "|" + LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST_EN +
            ")\\n{0,2}"
    );

    Pattern2 MESSAGE_WITH_BROADCAST_IN_DESCRIPTION_PATTERN = Pattern2.compile("" +
            "(?:" +
            "(?:" + LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_RU +
            "|" + LINK_TO_CONFERENCE_WITH_BROADCAST_PREFIX_EN +
            ")https://telemost\\.[^\\s]+\\n{1,2}" +
            "(?:" + LINK_TO_BROADCAST_PREFIX_RU +
            "|" + LINK_TO_BROADCAST_PREFIX_EN +
            ")https://telemost\\.[^\\s]+" +
            "|" + LINK_PROMISE_MESSAGE_WITH_BROADCAST_RU +
            "|" + LINK_PROMISE_MESSAGE_WITH_BROADCAST_EN +
            ")\\n{0,2}"
    );
}
