package ru.yandex.calendar.logic.telemost;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.tvm.TvmClient;
import ru.yandex.calendar.util.HttpClientConfiguration;

@Configuration
public class TelemostContextConfiguration {

    @Bean
    public TelemostClient telemostClient(
            @Value("${telemost.url}") String baseUrl,
            @Value("${telemost.tvm-id}") int tvmId,
            MeterRegistry registry,
            TvmClient tvmClient
    ) {
        val httpConfiguration = HttpClientConfiguration.fromProperties("telemost");
        return new TelemostClient(baseUrl, httpConfiguration, registry, tvmClient, tvmId);
    }

    @Bean
    public TelemostManager telemostManager() {
        return new TelemostManager();
    }

    @Bean
    public TelemostDescriptionPatcher telemostDescriptionPatcher() {
        return new TelemostDescriptionPatcher();
    }

    @Bean
    public TelemostEventDataPatcher telemostEventDataPatcher() {
        return new TelemostEventDataPatcher();
    }

    @Bean
    public TelemostPatcher telemostPatcher() {
        return new TelemostPatcher();
    }

    @Bean
    public TelemostJobStorage telemostJobStorage() {
        return new TelemostJobStorage();
    }
}
