package ru.yandex.calendar.logic.telemost;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.misc.lang.StringUtils;

public class TelemostDescriptionPatcher implements TelemostConstants {

    public void setConferenceLink(Event changes, Event source, String conferenceLink, Language lang) {
        String message = String.format(
                LINK_TO_CONFERENCE_WITHOUT_BROADCAST_TEMPLATE.getName(lang),
                conferenceLink);

        patchDescription(changes, source, message);
    }

    public void setConferenceAndBroadcastLinks(Event changes, Event source, String conferenceLink, String broadcastLink, Language lang) {
        String message = String.format(
                LINK_TO_CONFERENCE_WITH_BROADCAST_TEMPLATE.getName(lang),
                conferenceLink,
                broadcastLink
        );

        patchDescription(changes, source, message);
    }

    public void setConferencePromise(Event changes, Event source, Language lang) {
        String message = LINK_PROMISE_MESSAGE_WITHOUT_BROADCAST.getName(lang);

        patchDescription(changes, source, message);
    }

    public void setConferenceAndBroadcastPromise(Event changes, Event source, Language lang) {
        String message = LINK_PROMISE_MESSAGE_WITH_BROADCAST.getName(lang);

        patchDescription(changes, source, message);
    }

    public void cleanDescription(Event changes, Event source) {
        Option<String> description = source.getValueIfSet(EventFields.DESCRIPTION);

        if (description.isPresent()) {
            String cleaned = cleanDescription(description.get());

            if (!description.isSome(cleaned)) {
                changes.setDescription(cleaned);
            }
        }
    }

    private String cleanDescription(String description) {
        String descriptionWithoutOnlyConferenceLink = MESSAGE_WITHOUT_BROADCAST_IN_DESCRIPTION_PATTERN
                .matcher(description)
                .replaceAll("");

        return MESSAGE_WITH_BROADCAST_IN_DESCRIPTION_PATTERN
                .matcher(descriptionWithoutOnlyConferenceLink)
                .replaceAll("");
    }

    private void patchDescription(Event changes, Event source, String message) {
        String oldDescription = source.getValueIfSet(EventFields.DESCRIPTION)
                .map(this::cleanDescription)
                .orElse("");

        changes.setDescription(StringUtils.isEmpty(oldDescription)
                ? message + "\n"
                : message + "\n\n" + oldDescription);
    }
}
