package ru.yandex.calendar.logic.telemost;

import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.bender.RawJson;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;

public class TelemostEventDataPatcher implements TelemostConstants {

    public void setConferenceLink(Event changes, Event source, String conferenceLink) {
        ObjectNode object = getClonedJsonData(source);

        object.put(FIELD_CONFERENCE_LINK, conferenceLink);
        changes.setData(new RawJson(object.toString()));
    }

    public void setConferenceAndBroadcastLink(Event changes, Event source, String conferenceLink, String broadcastLink) {
        ObjectNode object = getClonedJsonData(source);

        object.put(FIELD_CONFERENCE_LINK, conferenceLink);
        object.put(FIELD_BROADCAST_LINK, broadcastLink);
        changes.setData(new RawJson(object.toString()));
    }

    public void cleanTelemostLinks(Event changes, Event source) {
        Option<RawJson> object = source.getValueIfSet(EventFields.DATA);

        if (object.isPresent()) {
            ObjectNode copy = object.get().getParsed().deepCopy();

            copy.remove(FIELD_CONFERENCE_LINK);
            copy.remove(FIELD_BROADCAST_LINK);
            changes.setData(new RawJson(copy.toString()));
        }
    }

    public void setNeedGenerate(
            Event changes, Event source,
            Option<Boolean> conference, Option<Boolean> broadcast
    ) {
        ObjectNode object = getClonedJsonData(source);

        conference.forEach(c -> object.put(FIELD_CONFERENCE_GENERATES, c));
        broadcast.forEach(b -> object.put(FIELD_BROADCAST_GENERATES, b));

        changes.setData(new RawJson(object.toString()));
    }

    private ObjectNode getClonedJsonData(Event event) {
        return event.getValueIfSet(EventFields.DATA)
                .map(RawJson::getParsed)
                .map(ObjectNode::deepCopy)
                .orElse(new ObjectNode(null));
    }
}
