package ru.yandex.calendar.logic.telemost;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.bender.RawJson;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;

class TelemostEventDataUtils implements TelemostConstants {

    public static boolean needGenerate(Event event) {
        return needGenerateConference(event) || needGenerateBroadcast(event);
    }

    public static boolean needGenerateConference(Event event) {
        return getBooleanNode(event, FIELD_CONFERENCE_GENERATES).orElse(false);
    }

    public static boolean needGenerateBroadcast(Event event) {
        return getBooleanNode(event, FIELD_BROADCAST_GENERATES).orElse(false);
    }

    public static boolean containsConferenceLink(Event event) {
        return getConferenceLink(event).isPresent();
    }

    public static boolean containsBroadcastLink(Event event) {
        return getBroadcastLink(event).isPresent();
    }

    public static boolean containsAnyLink(Event event) {
        return containsConferenceLink(event) || containsBroadcastLink(event);
    }

    public static boolean needGenerateAndNotContainsLink(Event event) {
        return (needGenerateConference(event) && !containsConferenceLink(event))
                || (needGenerateBroadcast(event) && !containsBroadcastLink(event));
    }

    public static Option<String> getConferenceLink(Event event) {
        return getTextNode(event, FIELD_CONFERENCE_LINK);
    }

    public static Option<String> getBroadcastLink(Event event) {
        return getTextNode(event, FIELD_BROADCAST_LINK);
    }

    private static Option<JsonNode> getDataNode(Event event, String name) {
        Option<RawJson> data = event.getValueIfSet(EventFields.DATA);

        return data.isPresent() && data.get().getParsed().has(name)
                ? Option.of(data.get().getParsed().get(name))
                : Option.empty();
    }

    private static Option<Boolean> getBooleanNode(Event event, String name) {
        return getDataNode(event, name).map(JsonNode::asBoolean);
    }

    private static Option<String> getTextNode(Event event, String name) {
        return getDataNode(event, name).filter(JsonNode::isTextual).map(JsonNode::textValue);
    }
}
