package ru.yandex.calendar.logic.telemost;

import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.worker.task.TelemostGenerateTask;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.impl.OnetimeUtils;
import ru.yandex.commune.bazinga.impl.storage.BazingaStorage;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;

@Slf4j
public class TelemostJobStorage {

    @Autowired
    private BazingaStorage bazingaStorage;

    public void saveOrMergeJob(OnetimeJob job) {
        bazingaStorage.addOnetimeJob(job, ActiveUidDuplicateBehavior.MERGE);
    }

    public void deleteJob(long eventId) {
        val activeJob = findActiveJob(eventId);

        if (activeJob.isPresent()) {
            bazingaStorage.deleteOnetimeJob(activeJob.get().getId());
            log.debug("Deleted generation job for {}", eventId);
        }
    }

    public Option<OnetimeJob> findActiveJob(TelemostGenerateTask task) {
        val activeUid = OnetimeUtils.getActiveUniqueIdentifier(task);
        return bazingaStorage.findOnetimeJobByActiveUid(activeUid);
    }

    Option<OnetimeJob> findActiveJob(long eventId) {
        return findActiveJob(new TelemostGenerateTask(eventId));
    }
}
