package ru.yandex.calendar.logic.telemost;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.calendar.util.idlent.YandexUser;
import ru.yandex.inside.passport.PassportUid;

public class TelemostPatcher {

    @Autowired
    private TelemostEventDataPatcher eventDataPatcher;
    @Autowired
    private TelemostDescriptionPatcher descriptionPatcher;
    @Autowired
    private UserManager userManager;
    @Autowired
    private SettingsRoutines settingsRoutines;

    public void patchLinks(
            Event changes, Event source,
            String conferenceLink, Option<String> broadcastLink,
            PassportUid creatorUid
    ) {
        Language lang = loadLanguage(creatorUid);

        if (broadcastLink.isPresent()) {
            descriptionPatcher.setConferenceAndBroadcastLinks(changes, source, conferenceLink, broadcastLink.get(), lang);
            eventDataPatcher.setConferenceAndBroadcastLink(changes, source, conferenceLink, broadcastLink.get());
        } else {
            descriptionPatcher.setConferenceLink(changes, source, conferenceLink, lang);
            eventDataPatcher.setConferenceLink(changes, source, conferenceLink);
        }
    }

    public void patchPromise(Event changes, Event source, PassportUid creatorUid) {
        Language lang = loadLanguage(creatorUid);

        if (TelemostEventDataUtils.needGenerateBroadcast(source)) {
            descriptionPatcher.setConferenceAndBroadcastPromise(changes, source, lang);
        } else if (TelemostEventDataUtils.needGenerateConference(source)) {
            descriptionPatcher.setConferencePromise(changes, source, lang);
        }
    }

    public void cleanDescriptionAndLinks(Event changes, Event source) {
        descriptionPatcher.cleanDescription(changes, source);
        eventDataPatcher.cleanTelemostLinks(changes, source);
    }

    public void setNeedGenerate(
            Event changes, Event source,
            Option<Boolean> conference, Option<Boolean> broadcast
    ) {
        eventDataPatcher.setNeedGenerate(changes, source, conference, broadcast);
    }

    private Language loadLanguage(PassportUid uid) {
        return userManager.getUserByUid(uid).flatMapO(YandexUser::getLanguage)
                .orElseGet(() -> settingsRoutines.getLanguage(uid));
    }
}
