package ru.yandex.calendar.logic.todo;

import java.util.regex.Pattern;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.util.HttpClientConfiguration;

@Configuration
public class TodoContextConfiguration {
    private static final Pattern METRICS_URI = Pattern.compile("^(/update_profile)");

    @Bean
    public TodoRoutines todoRoutines() {
        return new TodoRoutines();
    }

    @Bean
    public TodoListsXmlAppender todoListsXmlAppender() {
        return new TodoListsXmlAppender();
    }

    @Bean
    TodoListEmailManager todoListEmailManager() {
        return new TodoListEmailManager();
    }

    @Bean
    public YandexMailSettingsUpdater yandexMailSettingsUpdater(MeterRegistry meterRegistry,
                                                               @Value("${mail-settings.url}") String mailSettingsUrl,
                                                               @Value("${mail-settings.tvm-id}") int mailSettingsTVMid) {
        val httpClient = HttpClientConfiguration.fromProperties("mail-settings").consTrustAllClient(meterRegistry, "mail-settings", METRICS_URI);
        return new YandexMailSettingsUpdater(mailSettingsUrl, mailSettingsTVMid, httpClient);
    }
}
