package ru.yandex.calendar.logic.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.TodoExportToken;
import ru.yandex.calendar.logic.beans.generated.TodoExportTokenFields;
import ru.yandex.calendar.logic.beans.generated.TodoExportTokenHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class TodoExportTokenDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public void saveTokenByUid(PassportUid uid, String token) {
        TodoExportToken t = new TodoExportToken();

        t.setUid(uid);
        t.setToken(token);
        genericBeanDao.insertBean(t);
    }

    @RunWithRandomTest
    public Option<String> findTokenByUid(PassportUid uid) {
        return findTodoExportToken(TodoExportTokenFields.UID.eq(uid)).map(TodoExportToken.getTokenF());
    }

    @RunWithRandomTest
    public Option<PassportUid> findUidByToken(String token) {
        return findTodoExportToken(TodoExportTokenFields.TOKEN.eq(token)).map(TodoExportToken.getUidF());
    }

    public int deleteTokensByUids(ListF<PassportUid> uids) {
        return genericBeanDao.deleteBeans(TodoExportTokenHelper.INSTANCE, TodoExportTokenFields.UID.column().inSet(uids));
    }

    private Option<TodoExportToken> findTodoExportToken(SqlCondition c) {
        return genericBeanDao.findBean(TodoExportTokenHelper.INSTANCE, c);
    }
}
