package ru.yandex.calendar.logic.todo;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.TodoListEmail;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author gutman
 */
public class TodoListEmailDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    public long saveTodoListEmail(TodoListEmail todoListEmail) {
        return genericBeanDao.insertBeanGetGeneratedKey(todoListEmail);
    }

    @RunWithRandomTest
    public long findTodoListEmailsCountSentSince(PassportUid uid, Instant since) {
        String q = "SELECT COUNT(*) FROM todo_list_email WHERE uid = ? AND sent_ts >= ?";
        return getJdbcTemplate().queryForLong(q, uid, since);
    }

}
