package ru.yandex.calendar.logic.todo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.beans.generated.TodoList;

/**
* @author gutman
*/
public class TodoListsAndTodoItems {

    private final ListF<TodoList> todoLists;
    private final ListF<TodoItem> todoItems;
    private final int totalTodoLists;
    private final int totalTodoItems;

    public TodoListsAndTodoItems(ListF<TodoList> todoLists, ListF<TodoItem> todoItems, int totalTodoLists, int totalTodoItems) {
        this.todoLists = todoLists;
        this.todoItems = todoItems;
        this.totalTodoLists = totalTodoLists;
        this.totalTodoItems = totalTodoItems;
    }

    public ListF<TodoList> getTodoLists() {
        return todoLists;
    }

    public ListF<TodoItem> getTodoItems() {
        return todoItems;
    }

    public int getTotalTodoLists() {
        return totalTodoLists;
    }

    public int getTotalTodoItems() {
        return totalTodoItems;
    }

}
