package ru.yandex.calendar.logic.todo;

import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.beans.generated.SettingsFields;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.commune.mapObject.MapField;

/**
 * @author dbrylev
 */
public enum TodoMailType {
    PLANNED(SettingsFields.TODO_PLANNED_EMAIL_TM),
    EXPIRED(SettingsFields.TODO_EXPIRED_EMAIL_TM),
    ;

    private final MapField<Integer> settingsField;

    TodoMailType(MapField<Integer> settingsField) {
        this.settingsField = settingsField;
    }

    public static ListF<TodoMailType> types() {
        return Cf.list(PLANNED, EXPIRED);
    }

    public MapField<Integer> getSettingsField() {
        return settingsField;
    }

    public Option<LocalTime> getTime(Settings settings) {
        return settings.getFieldValueNullAsNone(settingsField).map(AuxDateTime.localTimeFromMillisOfDayF());
    }
}
