package ru.yandex.calendar.logic.todo;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author dbrylev
 */
public enum TodoStatus implements StringEnum {
    NEEDS_ACTION,
    COMPLETED,
    IN_PROGRESS,
    CANCELLED;

    public static final StringEnumResolver<TodoStatus> R = StringEnumResolver.r(TodoStatus.class);

    private final CamelWords camelName;

    private TodoStatus() {
        this.camelName = CamelWords.parse(name());
    }

    public static Option<TodoStatus> fromValueSafe(String value) {
        return Option.ofNullable(CamelWords.parse(value).toDbName()).filterMap(TodoStatus.R::fromValueO);
    }

    public String toIcsValue() {
        return camelName.toXmlName().toUpperCase();
    }

    @Override
    public String value() {
        return camelName.toDbName();
    }
}
