package ru.yandex.calendar.logic.update;

import ru.yandex.calendar.logic.event.ExternalId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.codec.Ui32Utils;
import ru.yandex.misc.lang.CamelWords;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class LockResource extends DefaultObject {

    private final Type type;
    private final long key;
    private final String value;

    public LockResource(Type type, long key) {
        this(type, key, Long.toString(key));
    }

    private LockResource(Type type, long key, String value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public static LockResource event(String externalId) {
        return event(new ExternalId(externalId));
    }

    public static LockResource event(ExternalId id) {
        long normalized = Ui32Utils.longValue(id.getNormalized().hashCode());
        long raw = Ui32Utils.longValue(id.getRaw().hashCode());

        return new LockResource(Type.EVENT, (normalized << 24) ^ raw, id.getRaw());
    }

    public static LockResource todoUser(PassportUid uid) {
        return new LockResource(Type.TODO_USER, uid.getUid());
    }

    public static LockResource layerUser(PassportUid uid) {
        return new LockResource(Type.LAYER_USER, uid.getUid());
    }

    public static LockResource settingsUser(PassportUid uid) {
        return new LockResource(Type.SETTINGS_USER, uid.getUid());
    }

    public static LockResource mailerUser(PassportUid uid) {
        return new LockResource(Type.MAILER_USER, uid.getUid());
    }

    public long getKey() {
        return type.key * 100000000000000000L + key % 100000000000000000L;
    }

    public String getValue() {
        return type.value + ":" + value;
    }

    public enum Type {
        EVENT(1),
        RESOURCE(2),
        TODO_USER(3),
        LAYER_USER(4),
        SETTINGS_USER(5),
        MAILER_USER(6),
        ;

        private final int key;
        private final String value;

        Type(int key) {
            this.key = key;
            this.value = CamelWords.parse(this.name()).toXmlName();
        }
    }
}
