package ru.yandex.calendar.logic.update;

import lombok.Getter;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.calendar.util.db.ListenableTransactionTemplate;

public class LockTransactionManager {
    @Autowired
    private UpdateLock2 updateLock2;
    @Autowired
    @Getter private TransactionTemplate transactionTemplate;

    public void lockAndDoInTransaction(LockResource resource, Function0V callback) {
        lockAndDoInTransaction(resource, callback.asFunction0ReturnNull());
    }

    public <A> A lockAndDoInTransaction(LockResource resource, Function0<A> callback) {
        return lockAndDoInTransaction(Cf.list(resource), callback);
    }

    public <A> A lockAndDoInTransaction(ListF<LockResource> resources, Function0V callback) {
        return lockAndDoInTransaction(resources, callback.asFunction0ReturnNull());
    }

    public <A> A lockAndDoInTransaction(ListF<LockResource> resources, final Function0<A> callback) {
        return lockAndDoInTransaction(() -> updateLock2.lockForUpdate(resources), callback);
    }

    public void lockAndDoInTransaction(Function0<LockHandle> locker, Function0V callback) {
        lockAndDoInTransaction(locker, callback.asFunction0ReturnNull());
    }

    public <A> A lockAndDoInTransaction(Function0<LockHandle> locker, Function0<A> callback) {
        return transactionTemplate.execute(status -> {
            try (val lock = locker.apply()) {
                return callback.apply();
            }
        });
    }

    public void doInTransaction(Runnable callback) {
        transactionTemplate.execute(status -> {
            callback.run();
            return null;
        });
    }

    // dirty hack to enable transaction propagation
    public <T> T lockAndDoInTransactionWithPropagation(Function0<LockHandle> locker, Function0<T> callback) {
        if (transactionTemplate instanceof ListenableTransactionTemplate) {
            val txTemplate = (ListenableTransactionTemplate) transactionTemplate;
            if (txTemplate.isInTransaction()) {
                try (val lock = locker.apply()) {
                    return callback.apply();
                }
            } else {
                return lockAndDoInTransaction(locker, callback);
            }
        } else {
            return lockAndDoInTransaction(locker, callback);
        }
    }
}
