package ru.yandex.calendar.logic.update;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.OptionalLong;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;

public class PgSemaphoreSettingsProvider extends CalendarJdbcDaoSupport implements SemaphoreSettingsProvider {
    @Override
    public Optional<SemaphoreSettings> getSettings(String key) {
        Option<SemaphoreSettings> settings = getJdbcTemplate().queryForOption("SELECT * FROM semaphore WHERE key = ?", this::parseSettings, key);
        return settings.toOptional();
    }

    @Override
    public void setSettings(String key, boolean rpsLimiter, int capacity, OptionalLong waitTimeout, long lockTimeoutMs) {
        var waitTimeoutMs = waitTimeout.isPresent() ? waitTimeout.getAsLong() : null;
        getJdbcTemplate().update(
                "INSERT INTO semaphore (key, rps_limiter, capacity, wait_timeout_ms, lock_timeout_ms) VALUES (?, ?, ?, ?, ?) ON CONFLICT (key) DO UPDATE SET rps_limiter = ?, capacity = ?, wait_timeout_ms = ?, lock_timeout_ms = ?",
                key, rpsLimiter, capacity, waitTimeoutMs, lockTimeoutMs, rpsLimiter, capacity, waitTimeoutMs, lockTimeoutMs
        );
    }

    @Override
    public void setNoLimit(String key) {
        getJdbcTemplate().update("DELETE FROM semaphore WHERE key = ?", key);
    }

    private SemaphoreSettings parseSettings(ResultSet rs, int rowNum) throws SQLException {
        var capacity = rs.getInt("capacity");
        var waitTimeoutMs = rs.getObject("wait_timeout_ms") != null ? OptionalLong.of(rs.getLong("wait_timeout_ms"))
                : OptionalLong.empty();
        var expirationTimeoutMs = rs.getLong("lock_timeout_ms");
        var rpsLimiter = rs.getBoolean("rps_limiter");
        return new SemaphoreSettings(rpsLimiter, capacity, waitTimeoutMs, expirationTimeoutMs);
    }
}
