package ru.yandex.calendar.logic.update;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Unit;
import ru.yandex.calendar.logic.event.dao.MainEventDao;
import ru.yandex.calendar.util.db.DbUtils;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;

/**
 * @author gutman
 */
public class UpdateLock2 {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLock2.class);

    @Autowired
    private MainEventDao mainEventDao;
    @Autowired
    private PgTransactionLocker pgTransactionLocker;

    private static final ThreadLocalX<Unit> acquired = new ThreadLocalX<>();

    public LockHandle lockEvent(long eventId) {
        return lockEvent(mainEventDao.findExternalIdsByEventIds(Cf.list(eventId)).singleO());
    }

    public LockHandle lockEvent(Option<String> externalId) {
        return lockForUpdate(externalId.map(LockResource::event));
    }

    public LockHandle lockForUpdate(ListF<LockResource> resources) {
        Check.isFalse(acquired.isSet(), "Lock is already acquired by this thread");
        Assert.isTrue(DbUtils.isInTransaction(), "Lock should be acquired inside transaction");

        pgTransactionLocker.lock(resources);

        acquired.set(Unit.U);

        return () -> {
            acquired.remove();
            LOG.info("releasing " + pgTransactionLocker.getKey(resources));
        };
    }

    public boolean isAcquired() {
        return acquired.isSet();
    }
}
