package ru.yandex.calendar.logic.user;

import javax.annotation.PreDestroy;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.email.Email;

/**
 * @author Roman Nefyodov
 */
public class BlackboxMultiplexed {

    private final Blackbox2 publicBlackbox;
    private final Blackbox2 ytBlackbox;

    public BlackboxMultiplexed(Blackbox2 publicBlackbox, Blackbox2 ytBlackbox) {
        this.publicBlackbox = publicBlackbox;
        this.ytBlackbox = ytBlackbox;
    }

    public Blackbox2 byAuthDomain(PassportAuthDomain passportAuthDomain) {
        return passportAuthDomain == PassportAuthDomain.PUBLIC ? publicBlackbox : ytBlackbox;
    }

    public Blackbox2 byUid(PassportUid uid) {
        return byAuthDomain(PassportAuthDomain.byUid(uid));
    }

    public Blackbox2 byEmail(Email email) {
        return byAuthDomain(PassportAuthDomain.byEmail(email));
    }

    public Blackbox2 getPublic() {
        return publicBlackbox;
    }

    @PreDestroy
    public void destroy() {
        publicBlackbox.destroy();

        if (ytBlackbox != publicBlackbox) {
            ytBlackbox.destroy();
        }
    }
}
