package ru.yandex.calendar.logic.user;

import java.io.File;
import java.io.IOException;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.resource.center.CenterResourceUpdater;
import ru.yandex.calendar.logic.staff.StaffSynchronizer;
import ru.yandex.calendar.logic.staff.YtStaffCache;
import ru.yandex.calendar.logic.staff.dao.GroupsDao;
import ru.yandex.calendar.logic.staff.dao.OfficesDao;
import ru.yandex.calendar.logic.staff.dao.RoomsDao;
import ru.yandex.calendar.logic.staff.dao.UsersDao;
import ru.yandex.calendar.micro.yt.StaffCache;
import ru.yandex.calendar.util.HttpClientConfiguration;
import ru.yandex.inside.center.client.rest.v1.CenterRestClient;
import ru.yandex.inside.center.client.rest.v1.internal.apache.ApacheHttpCenterRestClient;
import ru.yandex.inside.utils.OAuthAuthenticationHandler;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.oauth.OAuth;

import static org.apache.commons.io.FileUtils.readFileToString;

@Configuration
public class CenterContextConfiguration {
    @Value("${yt.center.url}")
    private String centerUrl;
    @Value("${yt.staff.url}")
    private String staffUrl;
    @Value("${yt.staff.token:-}")
    private String staffApiToken;
    @Value("${yt.staff.token.path:-}")
    private String staffApiTokenPath;
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private EnvironmentType environmentType;

    public final static String oauthClientId = "ddf75f6e16cb4e23873ca5df69627b18";
    public final static String oauthClientPassword = "df0d039a688a45868ebad0a5ded7c282";

    public boolean isCenterAccessible() {
        return passportAuthDomainsHolder.containsYandexTeamRu()
                && !staffApiToken.isEmpty()
                && environmentType != EnvironmentType.TESTS;
    }

    @Bean
    public Staff staff(MeterRegistry registry) throws IOException {
        if (environmentType == EnvironmentType.TESTS) {
            if (staffApiToken.isEmpty()) {
                if (staffApiTokenPath.isEmpty()) {
                    OAuth oauth = new OAuth();
                    staffApiToken = oauth.getOauthToken(oauthClientId, oauthClientPassword).get(0);
                } else {
                    staffApiToken = readFileToString(new File(staffApiTokenPath)).trim();
                }
            }
        }
        return new Staff(staffUrl, centerUrl, staffApiToken, HttpClientConfiguration.fromProperties("yt.center"), registry);
    }

    @Bean
    public StaffCache staffCache() {
        if (!isCenterAccessible()) {
            return new StaffCacheStub();
        }
        return new YtStaffCache();
    }

    @Bean
    public CenterRestClient centerClient() {
        HttpClientConfiguration conf = HttpClientConfiguration.fromProperties("yt.center");

        return new ApacheHttpCenterRestClient(
                centerUrl, new OAuthAuthenticationHandler(staffApiToken)::handle,
                conf.connectionTimeout, conf.socketTimeout, conf.maxConnections);
    }

    @Bean
    public CenterResourceUpdater centerResourceUpdater() {
        return new CenterResourceUpdater();
    }

    @Bean
    public CenterUserUpdater centerUserUpdater() {
        return new CenterUserUpdater();
    }

    @Bean
    public AvatarManager avatarManager(MeterRegistry registry) {
        return new AvatarManager(centerUrl, HttpClientConfiguration.fromProperties("yt.center"), registry);
    }

    @Bean
    public StaffSynchronizer staffSynchronizer(UsersDao usersDao, GroupsDao groupsDao, OfficesDao officesDao, RoomsDao roomsDao) {
        return new StaffSynchronizer(usersDao, groupsDao, officesDao, roomsDao);
    }
}
