package ru.yandex.calendar.logic.user;

import java.util.EnumSet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.logic.beans.IntegerArray;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

import static java.util.stream.Collectors.toCollection;


public enum Group implements IntEnum {
    SUPER_USER(0, ResourceType.values()),
    MASSAGE_ADMIN(1, ResourceType.MASSAGE_ROOM),
    PARKING_ADMIN(2, ResourceType.PARKING),
    APARTMENT_ADMIN(3, ResourceType.APARTMENT),
    APARTMENT_USER(9),
    MEETING_ROOM_ADMIN(4, ResourceType.ROOM, ResourceType.PRIVATE_ROOM, ResourceType.PROTECTED_ROOM, ResourceType.YAMONEY_ROOM),
    CAMPUS_ADMIN(5, ResourceType.CAMPUS),
    HOTEL_ADMIN(10, ResourceType.HOTEL),
    HOTEL_USER(11),
    ;

    private final int value;
    private final SetF<ResourceType> resourceTypesCanAdmin;

    Group(int value, ResourceType... resourceTypesCanAdmin) {
        this.value = value;
        this.resourceTypesCanAdmin = Cf.set(resourceTypesCanAdmin);
    }

    public int value() {
        return value;
    }

    public SetF<ResourceType> getResourceTypesCanAdmin() {
        return this.resourceTypesCanAdmin;
    }

    public static final IntEnumResolver<Group> R = IntEnumResolver.r(Group.class);

    public static EnumSet<Group> integerArrayToEnumSet(IntegerArray array) {
        return array.getElements().stream()
                .map(R::fromValue)
                .collect(toCollection(() -> EnumSet.noneOf(Group.class)));
    }

    public static SetF<ResourceType> getResourceTypesCanAdmin(SetF<Group> groups) {
        return groups.flatMap(Group::getResourceTypesCanAdmin).unique();
    }

    public static SetF<ResourceType> getResourceTypesCanBook(boolean isYaMoneyUser, SetF<Group> groups) {
        return (isYaMoneyUser
                ? ResourceType.yaMoneyBookableWithoutGroups()
                : ResourceType.bookableWithoutGroups()).plus(getResourceTypesCanAdmin(groups));
    }

    public static SetF<ResourceType> getResourceTypesCanView(SetF<Group> groups) {
        return ResourceType.viewableWithoutGroups().plus(getResourceTypesCanAdmin(groups))
                .plus(Option.when(groups.containsTs(APARTMENT_USER), ResourceType.APARTMENT))
                .plus(Option.when(groups.containsTs(HOTEL_USER), ResourceType.HOTEL));
    }

    public static SetF<ResourceType> getResourceTypesCanViewEvent(SetF<Group> groups) {
        return getResourceTypesCanView(groups);
    }

    public static SetF<ResourceType> getResourceTypesCanViewAnyEvent(SetF<Group> groups) {
        return getResourceTypesCanAdmin(groups)
                .plus(Option.when(groups.containsTs(APARTMENT_USER), ResourceType.APARTMENT))
                .plus(Option.when(groups.containsTs(HOTEL_USER), ResourceType.HOTEL));
    }
}
