package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class KarmaCheckAction {
    public static final BenderParserSerializer<KarmaCheckAction> ps = Bender.cons(KarmaCheckAction.class);

    private final long uid;
    private final String action;
    private final String name;
    private final Option<String> description;
    private final ActionSource source;

    public KarmaCheckAction(PassportUid uid, String action, Event event, ActionInfo actionInfo) {
        this(uid, action, event.getName(), Option.of(event.getDescription()), actionInfo);
    }

    public KarmaCheckAction(
            PassportUid uid, String action, String name, Option<String> description, ActionInfo actionInfo)
    {
        this.uid = uid.getUid();
        this.action = action;
        this.name = name;
        this.description = description;
        this.source = actionInfo.getActionSource();
    }

    public PassportUid getUid() {
        return PassportUid.cons(uid);
    }

    public static KarmaCheckAction invite(PassportUid uid, Event event, ActionInfo actionInfo) {
        return new KarmaCheckAction(uid, "event-invite", event, actionInfo);
    }

    public static KarmaCheckAction update(PassportUid uid, Event event, ActionInfo actionInfo) {
        return new KarmaCheckAction(uid, "event-update", event, actionInfo);
    }

    public static KarmaCheckAction inviteLayer(PassportUid uid, String layerName, ActionInfo actionInfo) {
        return new KarmaCheckAction(uid, "layer-invite", layerName, Option.empty(), actionInfo);
    }
}
