package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum Language implements StringEnum {
    RUSSIAN("ru"),
    ENGLISH("en", "en"),
    TURKISH("tr", "en"),
    TATAR("tt"),
    UKRAINIAN("uk"),
    AZERBAIJANI("az"),
    BELARUSIAN("be"),
    ARMENIAN("hy"),
    GEORGIAN("ka"),
    ROMANIAN("ro"),
    KAZAKH("kk"),
    ;

    public static final StringEnumResolver<Language> R = StringEnumResolver.r(Language.class);

    private final String value;
    private final String settingsValue;

    Language(String value) {
        this(value, "ru");
    }

    Language(String value, String settingsValue) {
        this.value = value;
        this.settingsValue = settingsValue;
    }

    public static Option<Language> fromValueSafe(String value) {
        return Option.ofNullable(value).filterMap(Language.R::fromValueO);
    }

    public Language getForSettings() {
        return R.fromValue(settingsValue);
    }

    public ru.yandex.inside.utils.Language iceberg() {
        switch (this) {
            case RUSSIAN: return ru.yandex.inside.utils.Language.RUSSIAN;
            case ENGLISH: return ru.yandex.inside.utils.Language.ENGLISH;
            case UKRAINIAN: return ru.yandex.inside.utils.Language.UKRAINIAN;
            case TURKISH: return ru.yandex.inside.utils.Language.TURKISH;
        }
        throw new IllegalArgumentException("No matching language found in iceberg for " + this);
    }

    @Override
    public String value() {
        return value;
    }
}
