package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@Bendable
public class LoginOrEmail {
    private final Either<String, Email> either;

    public LoginOrEmail(Either<String, Email> either) {
        this.either = either;
    }

    public static LoginOrEmail login(String login) {
        return new LoginOrEmail(Either.left(login));
    }

    public static LoginOrEmail email(Email email) {
        return new LoginOrEmail(Either.right(email));
    }

    @BenderTextValue
    public static LoginOrEmail parse(String value) {
        return new LoginOrEmail(value.indexOf('@') >= 0 ? Either.right(Emails.punycode(value)) : Either.left(value));
    }

    @BenderTextValue
    public String serialize() {
        return either.fold(s -> s, Emails::getUnicoded);
    }

    public Option<Email> getEmail() {
        return either.rightO();
    }

    public Option<String> getLogin() {
        return either.leftO();
    }
}
