package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * Name internationalization
 * @author ssytnik
 */
@BenderBindAllFields
public class NameI18n {
    private final String ru;
    private final Option<String> en;
    @Deprecated
    private final Option<String> enO = Option.empty();

    public NameI18n(String ru, Option<String> enO) {
        this.ru = ru;
        this.en = enO;
    }

    public NameI18n(String ru, String en) {
        this(ru, Option.of(en));
    }

    public static NameI18n empty() {
        return constant("");
    }

    public static NameI18n constant(String value) {
        return new NameI18n(value, Option.empty());
    }

    public String getName(Language language) {
        return language == Language.RUSSIAN ? ru : enOrRu();
    }

    public NameI18n concat(NameI18n that) {
        return new NameI18n(ru + that.ru, enOrRu() + that.enOrRu());
    }

    public NameI18n replace(String target, NameI18n replacement) {
        return new NameI18n(ru.replace(target, replacement.ru), enOrRu().replace(target, replacement.enOrRu()));
    }

    public static Function<Integer, NameI18n> plural(
            String ruForm1, String ruForm2, String ruForm5, String enForm1, String enForm2)
    {
        return quantity -> {
            int mod100 = Math.abs(quantity) % 100,
                    mod10 = mod100 % 10;

            String ruForm = mod100 > 10 && mod100 < 15 ? ruForm5
                    : mod10 > 1 && mod10 < 5 ? ruForm2
                    : mod10 == 1 ? ruForm1
                    : ruForm5;

            String enForm = quantity == 1 ? enForm1 : enForm2;

            return new NameI18n(quantity + " " + ruForm, quantity + " " + enForm);
        };
    }

    public ListF<String> getAllNames() {
        return Option.of(ru).plus(en());
    }

    private Option<String> en() {
        return en.orElse(enO);
    }

    private String enOrRu() {
        return en().orElse(ru);
    }

    public static Function<NameI18n, String> getNameF(ru.yandex.inside.utils.Language language) {
        return getNameF(Language.R.fromValue(language.value()));
    }

    public static Function<NameI18n, String> getNameF(final Language language) {
        return a -> a.getName(language);
    }
}
